﻿using Microsoft.AspNet.OData.Extensions;
using System.Web.Http;
using Microsoft.AspNet.OData.Builder;
using PpmsDataWebService.Models;
using PpmsDataWebService.VistaPharmacyModels;
using Microsoft.OData;
using Microsoft.OData.UriParser;

namespace PpmsDataWebService
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {
            // Web API configuration and services
            // Web API routes
            /*
            config.MapHttpAttributeRoutes();

            config.EnableDependencyInjection();

            config.Routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "v1.0/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );
            */

            //Ensures queries support these methods
            config.Count().Filter().OrderBy().Expand().Select().MaxTop(null);

            ODataModelBuilder builder = new ODataConventionModelBuilder();
            //Models
            //Metadata
            builder.EntitySet<Response>("Response");
            builder.EntitySet<VistaPharmacyResponse>("VistaPharmacyResponse");
            

            //Provider Networks
            builder.EntitySet<ProviderNetwork>("ProviderNetworks");
            //Visns
            builder.EntitySet<Visn>("Visns");
            //Visn Functions
            builder.Function("GetVisnByName").Returns<Visn>();
            builder.Function("GetVisnByNumber").Returns<Visn>();
            //Agreement Providers
            builder.EntitySet<AgreementProvider>("AgreementProviders");
            //Care Sites
            builder.EntitySet<CareSite>("CareSites");
            //Care Site Functions
            builder.Function("GetCareSiteByCity").Returns<CareSite>();
            builder.Function("GetCareSiteByState").Returns<CareSite>();
            builder.Function("GetCareSiteByZip").Returns<CareSite>();
            builder.Function("GetCareSiteByNameAddress").Returns<CareSite>();
            //Facilities
            builder.EntitySet<Facility>("Facilities");
            //Facility Functions
            builder.Function("GetFacilityByCity").Returns<Facility>();
            builder.Function("GetFacilityByState").Returns<Facility>();
            builder.Function("GetFacilityByZipCode").Returns<Facility>();
            builder.Function("GetFacilityByRegion").Returns<Facility>();

            //Intitutions
            builder.EntitySet<Institution>("Institutions");
            //Provider Agreements
            builder.EntitySet<ProviderAgreement>("ProviderAgreements");
            //Provider Contacts
            builder.EntitySet<ProviderContact>("ProviderContacts");
            //Provider Credentials
            builder.EntitySet<ProviderCredential>("ProviderCredentials");
            //Provider Identifiers
            builder.EntitySet<ProviderIdentifier>("ProviderIdentifiers");
            //Provider Licenses
            builder.EntitySet<ProviderLicense>("ProviderLicenses");
            //Provider Privileges
            builder.EntitySet<ProviderPrivilege>("ProviderPrivileges");
            //Providers
            builder.EntitySet<Provider>("Providers");
           
            //Provider Functions
            builder.Function("ProviderGroupSearch").Returns<Provider>();
            builder.Function("GetProviderByName").Returns<Provider>();
            builder.Function("GetProviderNetworks").Returns<Provider>();
            builder.Function("GetProvidersByNetwork").Returns<Provider>();
            builder.Function("GetProvidersByAffiliationType").Returns<Provider>();
            builder.Function("GetProvidersByRelationship").Returns<Provider>();
            builder.Function("GetProvidersByActiveDateRange").Returns<Provider>();
            builder.Function("GetProvidersByModifiedOnDate").Returns<Provider>();
            //builder.Function("GetProvidersByModifiedOnDateV2").ReturnsCollectionFromEntitySet<Response>("Response");
            builder.Function("GetModifiedProviders").ReturnsCollectionFromEntitySet<Response>("Response");
            builder.Function("GetProvidersAuthorized").Returns<ProviderAuthorization>();
            //Provider Services
            builder.EntitySet<ProviderService>("ProviderServices");
            //Provider Specialties
            builder.EntitySet<ProviderSpecialty>("ProviderSpecialties");
            //Service Availabilities
            builder.EntitySet<ServiceAvailability>("ServiceAvailabilities");
            //Specialties
            builder.EntitySet<Specialty>("Specialties");
            //Va Provider Relationships
            builder.EntitySet<VaProviderRelationship>("VaProviderRelationships");
            //Provider Locator
            //Provider Locator Function 
            builder.Function("ProviderLocator").Returns<ProviderLocatorResult>();
            //VA Facility Locator Function
            builder.Function("VAFacilityLocator").Returns<VAFacilityLocatorResult>();
            //PIE Functions
            //Vista Pharmacy Models
            //builder.EntitySet<VistaPharmacyProvider>("VistaPharmacyProviders");
            //builder.EntitySet<VistaPharmacyProviderService>("VistaPharmacyProviderServices");
            //builder.EntitySet<VistaPharmacyProviderIdentifier>("VistaPharmacyProviderIdentifiers");
            //builder.EntitySet<VistaPharmacyDEA>("VistaPharmacyDEAs");
            //builder.EntitySet<VistaPharmacyMedicalEducation>("VistaPharmacyMedicalEducations");

            //builder.Function("GetProvidersVistaPharmacy").ReturnsCollectionFromEntitySet<VistaPharmacyResponse>("VistaPharmacyResponse");


            config.MapODataServiceRoute("odata", "v1.0", builder.GetEdmModel());
       
        }

        static void ConfigureODataServices(IContainerBuilder builder)
        {
            builder.AddService(ServiceLifetime.Singleton, typeof(ODataUriResolver), sp => new CaseInsensitiveODataUriResolver());
        }

    }
}
